// Provides default request limit values for any request settings where the value is missing

'use strict';

var REQUEST_LIMIT = 'submittedRequestLimit';

var docCount = 0;
var settingCount = 0;
var failedSettingCount = 0;

function getDefaultRequestLimit(typeOfCareId) {
    // 1 for primary care, else 2
    return typeOfCareId === '323' ? 1 : 2;
}

if (db._name !== 'var-utility') {
    print('Script must be executed on the var-utility database.');
} else {
    var collection = db.requestEligibilityCriteria;
    var count;

    count = collection.find({
        $or: [
            {'requestSettings.submittedRequestLimit': {$in: [null, 0]}},
            {'customRequestSettings.submittedRequestLimit': {$in: [null, 0]}}
        ]
    }).count();
    print(count, 'document(s) with null, missing, or 0 request limit');

    collection.find().forEach(function (doc) {
        var docUpdated = false;

        ['requestSettings', 'customRequestSettings'].forEach(function (settingsProperty) {
            if (doc[settingsProperty]) {
                doc[settingsProperty].forEach(function (settingsItem, index) {
                    var set;
                    var requestLimitProperty;
                    var result;

                    if (!settingsItem[REQUEST_LIMIT]) {
                        requestLimitProperty = settingsProperty + '.' + index + '.' + REQUEST_LIMIT;
                        set = {};
                        set[requestLimitProperty] = NumberInt(getDefaultRequestLimit(settingsItem._id));
                        result = collection.update({_id: doc._id}, {$set: set});
                        docUpdated = Boolean(result.nModified);
                        if (docUpdated) {
                            settingCount++;
                        } else {
                            failedSettingCount++;
                        }
                    }
                });
            }
        });

        if (docUpdated) {
            docCount++;
        }
    });

    print('Set', settingCount, 'default request limit values in', docCount, 'document(s).');
    print('Failed to set', failedSettingCount, 'request limit values.');

    count = collection.find({
        $or: [
            {'requestSettings.submittedRequestLimit': {$in: [null, 0]}},
            {'customRequestSettings.submittedRequestLimit': {$in: [null, 0]}}
        ]
    }).count();
    print(count, 'document(s) with null, missing, or 0 request limit');
}
